 use "${tmp}/regfile", clear

	
	drop if mi(ZE2010) | mi(ape)
	keep if inrange(year, 2004, 2019)	

	drop if inlist(substr(ZE2010,1, 2), "94", "01", "02", "03", "04", "05", "06") //Corse + dom tom
	
	gen job_eng_hrly_wage = job_eng_sbrut / job_eng_hrs

	foreach var in  job_eng_hrly_wage  job_eng_hrs job_eng_sbrut {
		qui replace `var' = 0 if mi(`var')
		qui gen ln_`var'	 = ln(`var')
	}
	
	encode ape, gen(ape_n)
	gen naf2d = real(substr(ape,1,2))

	egen gp = group(ape_n ZE2010)


	ren *_job* **
	ren *hrly_wage* *hrwg*
	
	merge m:1 ZE2010 ape using "${tmp}/status_ZENAF"
	destring ZE2010, replace force
	drop if inlist(naf2d,64,70)
	
	recode E_???? E_post11  EP* (missing = 0) 
save "${tmp}/Regfile_nafZE", replace
	